/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.digital;

import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSink;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.digital.DigitalComponentBase;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class RandomizerComponent
extends DigitalComponentBase<RandomizerComponent> {
    private static final AABB BOUNDS = new AABB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private static final Property<Boolean> PROP_ON = BooleanProperty.m_61465_((String)"on");
    private static final VecDirectionFlags OUTPUT_SIDES = VecDirectionFlags.horizontals();
    private static final InterfaceLookup<RandomizerComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSource.class, OUTPUT_SIDES, RandomizerComponent::getRedstoneSource).with(RedstoneSink.class, DigitalComponentBase.DEFAULT_INPUT_SIDES, RedstoneSink::instance).build();
    private boolean previousInput = false;
    private boolean state = false;

    public RandomizerComponent(ComponentContext context) {
        super(SCMComponents.RANDOMIZER, context, INTERFACES);
    }

    private RandomizerComponent(ComponentContext context, boolean state) {
        this(context);
        this.state = state;
    }

    public CircuitComponent copyRotated(ComponentContext context, Rotation rotation) {
        return new RandomizerComponent(context, this.state);
    }

    public ComponentState getState() {
        return (ComponentState)super.getState().m_61124_(PROP_ON, (Comparable)Boolean.valueOf(this.state));
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)SCMItems.RANDOMIZER.get());
    }

    @Override
    protected boolean beforeCheckInputs(ComponentEventMap events, boolean tick) {
        if (tick) {
            boolean input;
            boolean bl = input = this.getInputs() != 0;
            if (input && !this.previousInput) {
                this.randomize();
            }
            this.previousInput = input;
        }
        return true;
    }

    @Override
    protected void onNewInputs(boolean tick, byte newInputs) {
        if (this.getInputs() == 0 != (newInputs == 0)) {
            this.scheduleTick(1);
        }
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128379_("previous_input", this.previousInput);
        tag.m_128379_("state", this.state);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.previousInput = tag.m_128471_("previous_input");
        this.state = tag.m_128471_("state");
    }

    private void randomize() {
        boolean newState;
        boolean bl = newState = Math.random() > 0.5;
        if (newState == this.state) {
            return;
        }
        this.updateExternalState(true, () -> {
            this.state = newState;
        });
        this.sendEvent(CircuitEvent.REDSTONE, OUTPUT_SIDES);
    }

    private RedstoneSource getRedstoneSource() {
        return this.state ? RedstoneSource.fullWeak() : RedstoneSource.off();
    }

    public static void createState(StateDefinition.Builder<ComponentType, ComponentState> builder) {
        builder.m_61104_(new Property[]{PROP_ON});
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)SCMItems.RANDOMIZER.get());
        }
    }
}

